<?php

class UserTeacherLoginForm extends CFormModel
{
	public $login;
	public $password;

	private $identity;

	public function rules()
	{
		return array(
			array('login, password', 'required'),
			array('password', 'authenticate'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'login'=>'Login',
			'password'=>'Hasło',
		);
	}

	public function authenticate($attribute,$params)
	{
		if(!$this->hasErrors())
		{
			$this->identity = new UserTeacherIdentity($this->login, $this->password);

			if(!$this->identity->authenticate())
				$this->addError('password', 'Błędne dane.');
		}
	}

	public function login()
	{
		if($this->identity === null)
		{
			$this->identity = new UserTeacherIdentity($this->login, $this->password);
			$this->identity->authenticate();
		}

		if($this->identity->errorCode === UserTeacherIdentity::ERROR_NONE)
		{
			Yii::app()->user->login($this->identity, 0);
			return true;
		}
		else
			return false;
	}

	public function logout()
	{
		if($this->identity->errorCode === UserTeacherIdentity::ERROR_NONE)
		{
			$this->identity = null;
			Yii::app()->user->logout();
			return true;
		}

		return false;
	}
}